async function smeltItem(bot, itemName, count = 1) {
    // return if itemName or fuelName is not string
    if (typeof itemName !== "string" || typeof fuelName !== "string") {
        throw new Error("itemName or fuelName for smeltItem must be a string");
    }
    // return if count is not a number
    if (typeof count !== "number") {
        throw new Error("count for smeltItem must be a number");
    }
    const item = mcData.itemsByName[itemName];
    if (!item) {
        throw new Error(`No item named ${itemName}`);
    }
    // List of possible fuels (you can expand this list as needed)
    const possibleFuels = [
        "coal",
        "charcoal",
        'acacia_log', 'birch_log', 'cherry_log', 'dark_oak_log', 'jungle_log', 'mangrove_log', 'oak_log', 'spruce_log', 'stripped_acacia_log', 'stripped_birch_log', 'stripped_cherry_log', 'stripped_dark_oak_log', 'stripped_jungle_log', 'stripped_mangrove_log', 'stripped_oak_log', 'stripped_spruce_log',
        'acacia_planks', 'bamboo_planks', 'birch_planks', 'cherry_planks', 'crimson_planks', 'dark_oak_planks', 'jungle_planks', 'mangrove_planks', 'oak_planks', 'spruce_planks', 'warped_planks',
        'acacia_wood', 'birch_wood', 'cherry_wood', 'dark_oak_wood', 'jungle_wood', 'mangrove_wood', 'oak_wood', 'spruce_wood', 'stripped_acacia_wood', 'stripped_birch_wood', 'stripped_cherry_wood', 'stripped_dark_oak_wood', 'stripped_jungle_wood', 'stripped_mangrove_wood', 'stripped_oak_wood', 'stripped_spruce_wood',
        "lava_bucket",
        "stick",
        "blaze_rod",
    ];
    const furnaceBlock = bot.findBlock({
        matching: mcData.blocksByName.furnace.id,
        maxDistance: 32,
    });
    if (!furnaceBlock) {
        throw new Error("No furnace nearby");
    } else {
        await bot.pathfinder.goto(
            new GoalLookAtBlock(furnaceBlock.position, bot.world)
        );
    }
    const furnace = await bot.openFurnace(furnaceBlock);
    let success_count = 0;
    for (let i = 0; i < count; i++) {
        if (!bot.inventory.findInventoryItem(item.id, null)) {
            bot.chat(`No ${itemName} to smelt in inventory`);
            break;
        }
        // Find the first available fuel in the inventory
        let fuel = null;
        for (const fuelName of possibleFuels) {
            fuel = bot.inventory.findInventoryItem(mcData.itemsByName[fuelName]?.id);
            if (fuel) break; // Use the first fuel found
        }

        if (!fuel) {
            throw new Error("No valid fuel found in inventory");
        }

        if (furnace.fuelSeconds < 15 && furnace.fuelItem()?.name !== fuelName) {
            if (!bot.inventory.findInventoryItem(fuel.id, null)) {
                bot.chat(`No ${fuelName} as fuel in inventory`);
                break;
            }
            await furnace.putFuel(fuel.id, null, 1);
            await bot.waitForTicks(20);
            if (!furnace.fuel && furnace.fuelItem()?.name !== fuelName) {
                throw new Error(`${fuelName} is not a valid fuel`);
            }
        }
        await furnace.putInput(item.id, null, 1);
        await bot.waitForTicks(12 * 20);
        if (!furnace.outputItem()) {
            throw new Error(`${itemName} is not a valid input`);
        }
        await furnace.takeOutput();
        success_count++;
    }
    furnace.close();
    if (success_count > 0) bot.chat(`Smelted ${success_count} ${itemName}.`);
    else {
        bot.chat(
            `Failed to smelt ${itemName}, please check the fuel and input.`
        );
        _smeltItemFailCount++;
        if (_smeltItemFailCount > 10) {
            throw new Error(
                `smeltItem failed too many times, please check the fuel and input.`
            );
        }
    }
}
